/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.outconn;

import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rcs.conndata.ConnectionInfoManager;
import com.ibm.hwmca.fw.rcs.conndata.DisplayableCountry;
import com.ibm.hwmca.fw.rcs.conndata.DisplayableSubdivision;
import com.ibm.hwmca.fw.rcs.conndata.PhoneInfo;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigData;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigEvent;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigListener;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigManager;
import com.ibm.hwmca.fw.rcs.outconn.AddPhoneNumberBean;
import com.ibm.hwmca.fw.rcs.outconn.EditPhoneNumberBean;
import com.ibm.hwmca.fw.rcs.outconn.LocalModemBean;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConnectivityConstants;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConnectivityTasklet;
import com.ibm.hwmca.fw.rcs.outconn.TestPhoneNumberBean;
import com.ibm.hwmca.fw.rcs.outconn.TestPhoneNumberThread;
import com.ibm.hwmca.fw.rcs.path.PathPlatform;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LocalModemTasklet
extends PanelTasklet
implements OutboundConnectivityConstants,
ModemConfigListener {
    private static final String TRACE_MASKT = "XRCSLMTT";
    private static final String TRACE_MASKF = "XRCSLMTF";
    private static final String TRACE_MASKD = "XRCSLMTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-LMdmTskl");
    private LocalModemBean localModemBean;
    private TestPhoneNumberThread testPhoneNumberThread;
    private List availCountries;
    private Map availSubdivisions;
    private String lastCountryCode = "";
    private String lastSubdivCode = "";
    private PathPlatform pathPlatform = null;

    public LocalModemTasklet() {
        Trace.trace(TRACE_MASKT, "<> LocalModemTasklet()");
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> init()");
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    public void destroy() {
        Trace.trace(TRACE_MASKT, "-> destroy()");
        ModemConfigManager modemConfigMgr = ModemConfigManager.getModemConfigManager();
        modemConfigMgr.removeModemConfigListener(this);
        this.deactiviateTestThread();
        super.destroy();
        Trace.trace(TRACE_MASKT, "<- destroy()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service(" + request + ", " + response + ")");
        try {
            if (request.isInitialRequest()) {
                this.pathPlatform = (PathPlatform)request.getData("PathPlatform");
                this.localModemBean = new LocalModemBean();
                this.localModemBean.setBeanName("LocalModemBean");
                OutboundConnectivityTasklet outConnTasklet = (OutboundConnectivityTasklet)this.getParent();
                OutboundConfigData outConfigData = outConnTasklet.getOutboundConfigData();
                this.localModemBean.setCallHomeServer(outConfigData.isCallHomeServer());
                this.localModemBean.setAllowDial(outConfigData.isAllowDial());
                this.localModemBean.setPhoneNumbers(outConfigData.getPhoneInfo());
                ModemConfigManager modemConfigMgr = ModemConfigManager.getModemConfigManager();
                ModemConfigData modemConfigData = modemConfigMgr.getModemConfig();
                this.localModemBean.setDialPrefix(modemConfigData.getDialPrefix());
                modemConfigMgr.addModemConfigListener(this);
                Locale locale = this.clientInformation.getLocale();
                ConnectionInfoManager connInfoMgr = ConnectionInfoManager.getConnectionInfoManager();
                this.availCountries = connInfoMgr.getDisplayableCountries(locale);
                this.availSubdivisions = connInfoMgr.getDisplayableSubdivisions(locale);
                response.replace("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnRes", "LocalModemPanel", this.localModemBean);
            } else if (request.isDisposed() || request.isCanceled()) {
                response.terminate();
            } else {
                String source = (String)request.getData("Source");
                if (source == null) {
                    source = "";
                }
                Trace.trace(TRACE_MASKF, "source=" + source);
                if (source.equals("")) {
                    Trace.trace(TRACE_MASKF, "Unspecified source");
                    response.noAction();
                } else if (source.equals("LocalModemPanel")) {
                    this.serviceLocalModemPanel(request, response);
                } else if (source.equals("AddPhoneNumberPanel")) {
                    this.serviceAddPhoneNumberPanel(request, response);
                } else if (source.equals("EditPhoneNumberPanel")) {
                    this.serviceEditPhoneNumberPanel(request, response);
                } else if (source.equals("TestPhoneNumberPanel")) {
                    this.serviceTestPhoneNumberPanel(request, response);
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown source");
                    response.noAction();
                }
            }
        }
        catch (TaskletException te) {
            throw te;
        }
        catch (Exception e) {
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKT, "<- service()");
    }

    public void modemConfigChanged(ModemConfigEvent event) {
        Trace.trace(TRACE_MASKF, "-> modemConfigChanged()");
        ModemConfigData configData = event.getModemConfigData();
        PanelTaskletRequest request = new PanelTaskletRequest();
        request.setData("Source", "LocalModemPanel");
        request.setData("Command", "UpdateDialPrefix");
        request.setData("DialPrefix", configData.getDialPrefix());
        try {
            this.postRequest("LocalModemBean", request);
        }
        catch (TaskletException te) {
            Trace.trace(TRACE_MASKT, "TaskletException: " + te.getMessage());
        }
        Trace.trace(TRACE_MASKF, "<- modemConfigChanged()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(classLogInfo, 1940, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }

    private void serviceLocalModemPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceLocalModemPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("OpenAddPanel")) {
            AddPhoneNumberBean addPhoneNumberBean = new AddPhoneNumberBean();
            addPhoneNumberBean.setBeanName("AddPhoneNumberBean");
            String countryCode = this.getInitCountryCode();
            String subdivCode = this.getInitSubdivisionCode(countryCode);
            ConnectionInfoManager connInfoMgr = ConnectionInfoManager.getConnectionInfoManager();
            List predefinedNumbers = connInfoMgr.getPhoneInfo("ATT", countryCode, subdivCode);
            ModemConfigManager modemConfigMgr = ModemConfigManager.getModemConfigManager();
            ModemConfigData modemConfigData = modemConfigMgr.getModemConfig();
            addPhoneNumberBean.setDialPrefix(modemConfigData.getDialPrefix());
            addPhoneNumberBean.setAvailCountries(this.availCountries);
            addPhoneNumberBean.setCountryCode(countryCode);
            addPhoneNumberBean.setAvailSubdivisions(this.availSubdivisions);
            addPhoneNumberBean.setSubdivisionCode(subdivCode);
            addPhoneNumberBean.setAvailPredefinedNumbers(predefinedNumbers);
            response.openModalChild("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnRes", "AddPhoneNumberPanel", addPhoneNumberBean);
        } else if (command.equals("AddPhoneNumber")) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("Command", command);
            data.put("PhoneInfo", request.getData("PhoneInfo"));
            response.update("LocalModemBean", data);
        } else if (command.equals("OpenEditPanel")) {
            EditPhoneNumberBean editPhoneNumberBean = new EditPhoneNumberBean();
            editPhoneNumberBean.setBeanName("EditPhoneNumberBean");
            ModemConfigManager modemConfigMgr = ModemConfigManager.getModemConfigManager();
            ModemConfigData modemConfigData = modemConfigMgr.getModemConfig();
            editPhoneNumberBean.setDialPrefix(modemConfigData.getDialPrefix());
            editPhoneNumberBean.setPhoneInfo((PhoneInfo)request.getData("PhoneInfo"));
            response.openModalChild("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnRes", "EditPhoneNumberPanel", editPhoneNumberBean);
        } else if (command.equals("UpdatePhoneNumber")) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("Command", command);
            data.put("PhoneInfo", request.getData("PhoneInfo"));
            response.update("LocalModemBean", data);
        } else if (command.equals("OpenTestPanel")) {
            TestPhoneNumberBean testPhoneNumberBean = new TestPhoneNumberBean();
            testPhoneNumberBean.setBeanName("TestPhoneNumberBean");
            ModemConfigManager modemConfigMgr = ModemConfigManager.getModemConfigManager();
            ModemConfigData modemConfigData = modemConfigMgr.getModemConfig();
            testPhoneNumberBean.setDialPrefix(modemConfigData.getDialPrefix());
            testPhoneNumberBean.setPhoneInfo((PhoneInfo)request.getData("PhoneInfo"));
            response.openModalChild("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnRes", "TestPhoneNumberPanel", testPhoneNumberBean);
        } else if (command.equals("OpenModemConfigPanel")) {
            DisplayAreaDescriptorDelegate delegate = null;
            String tasklet = "com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigTasklet";
            delegate = new DisplayAreaDescriptorDelegate(tasklet, null);
            delegate.setMountPoint(null);
            response.openModalChild(delegate);
        } else if (command.equals("UpdateDialPrefix")) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("Command", command);
            data.put("DialPrefix", request.getData("DialPrefix"));
            response.update("LocalModemBean", data);
        } else if (command.equals("Commit")) {
            LocalModemBean bean = (LocalModemBean)request.getData("Bean");
            if (bean != null) {
                OutboundConnectivityTasklet outConnTasklet = (OutboundConnectivityTasklet)this.getParent();
                OutboundConfigData outConfigData = outConnTasklet.getOutboundConfigData();
                outConfigData.setAllowDial(bean.isAllowDial());
                outConfigData.setPhoneInfo(bean.getPhoneNumbers());
            }
            response.noAction();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceLocalModemPanel()");
    }

    private void serviceAddPhoneNumberPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceAddPhoneNumberPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("GetUpdate")) {
            String subdivCode;
            String countryCode;
            this.lastCountryCode = countryCode = (String)request.getData("CountyCode");
            this.lastSubdivCode = subdivCode = (String)request.getData("SubdivisionCode");
            ConnectionInfoManager connInfoMgr = ConnectionInfoManager.getConnectionInfoManager();
            List predefinedNumbers = connInfoMgr.getPhoneInfo("ATT", countryCode, subdivCode);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("Command", command);
            data.put("PredefinedNumbers", predefinedNumbers);
            response.update("AddPhoneNumberBean", data);
        } else if (command.equals("Commit")) {
            response.dispose();
            PanelTaskletRequest newRequest = new PanelTaskletRequest();
            newRequest.setData("Source", "LocalModemPanel");
            newRequest.setData("Command", "AddPhoneNumber");
            newRequest.setData("PhoneInfo", request.getData("PhoneInfo"));
            this.postRequest("LocalModemBean", newRequest);
        } else if (command.equals("Cancel")) {
            response.dispose();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceAddPhoneNumberPanel()");
    }

    private void serviceEditPhoneNumberPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceEditPhoneNumberPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("Commit")) {
            response.dispose();
            PanelTaskletRequest newRequest = new PanelTaskletRequest();
            newRequest.setData("Source", "LocalModemPanel");
            newRequest.setData("Command", "UpdatePhoneNumber");
            newRequest.setData("PhoneInfo", request.getData("PhoneInfo"));
            this.postRequest("LocalModemBean", newRequest);
        } else if (command.equals("Cancel")) {
            response.dispose();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceEditPhoneNumberPanel()");
    }

    private void serviceTestPhoneNumberPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceTestPhoneNumberPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("Start")) {
            PhoneInfo phoneInfo = (PhoneInfo)request.getData("PhoneInfo");
            this.testPhoneNumberThread = new TestPhoneNumberThread(this, phoneInfo, this.pathPlatform);
            this.testPhoneNumberThread.start();
            response.noAction();
        } else if (command.equals("Stop")) {
            this.deactiviateTestThread();
            response.noAction();
        } else if (command.equals("UpdateStatus")) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("Command", command);
            data.put("StatusInfo", request.getData("StatusInfo"));
            response.update("TestPhoneNumberBean", data);
        } else if (command.equals("TestComplete")) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("Command", command);
            response.update("TestPhoneNumberBean", data);
        } else if (command.equals("Cancel")) {
            this.deactiviateTestThread();
            response.dispose();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceTestPhoneNumberPanel()");
    }

    private void deactiviateTestThread() {
        Trace.trace(TRACE_MASKT, "-> deactivateTestThread()");
        if (this.testPhoneNumberThread != null) {
            this.testPhoneNumberThread.cancel();
        } else {
            Trace.trace(TRACE_MASKF, "No test thread active");
        }
        Trace.trace(TRACE_MASKT, "<- deactivateTestThread()");
    }

    private String getInitCountryCode() {
        String countryCode = "";
        if (!this.lastCountryCode.equals("")) {
            countryCode = this.lastCountryCode;
        } else {
            CustomerInfoManager custInfoMgr = CustomerInfoManager.getCustomerInfoManager();
            CustomerInfoData custInfo = custInfoMgr.getCustomerInfo();
            countryCode = custInfo.getSystemCountryCode();
            if (countryCode.equals("")) {
                Locale locale = this.clientInformation.getLocale();
                countryCode = locale.getCountry();
            }
        }
        boolean found = false;
        Iterator iterator = this.availCountries.iterator();
        while (iterator.hasNext()) {
            DisplayableCountry country = (DisplayableCountry)iterator.next();
            if (!country.getIsoCode().equals(countryCode)) continue;
            found = true;
            break;
        }
        if (!found) {
            countryCode = "";
        }
        this.lastCountryCode = countryCode;
        return countryCode;
    }

    private String getInitSubdivisionCode(String countryCode) {
        String subdivCode = "";
        boolean countryHasSubdivs = this.availSubdivisions.containsKey(countryCode);
        if (!this.lastSubdivCode.equals("")) {
            subdivCode = this.lastSubdivCode;
        } else {
            CustomerInfoManager custInfoMgr = CustomerInfoManager.getCustomerInfoManager();
            CustomerInfoData custInfo = custInfoMgr.getCustomerInfo();
            subdivCode = custInfo.getSystemSubdivisionCode();
            if (subdivCode.equals("") && countryHasSubdivs) {
                List subdivs = (List)this.availSubdivisions.get(countryCode);
                subdivCode = ((DisplayableSubdivision)subdivs.get(0)).getIsoCode();
            }
        }
        boolean found = false;
        if (countryHasSubdivs) {
            List subdivs = (List)this.availSubdivisions.get(countryCode);
            Iterator iterator = subdivs.iterator();
            while (iterator.hasNext()) {
                DisplayableSubdivision subdiv = (DisplayableSubdivision)iterator.next();
                if (!subdiv.getIsoCode().equals(subdivCode)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            subdivCode = "";
        }
        this.lastSubdivCode = subdivCode;
        return subdivCode;
    }
}

